



 
 /***************************************************************************************************************
  *                              Example_1. ET-REMOTE MP3 Trig-Mode By Command RS232                            *
  ***************************************************************************************************************
  *																					                            *
  *  Target MCU    : LPC2138 (CP-JRARM7 LPC2138)                                                                *
  *       	       : X-TAL : 19.6608 MHz                                                                        * 
  *                : PLL Setup = M(3),P(2)	                                                                    *
  *                : Run Speed 58.9824 MHz(With PLL)(19.6608MHz x 3 = 58.9824 MHz                               *         
  *                : VPB Clock(pclk) = CPU Clock/2 = 58.9824MHz/2 = 29.4912 MHz                                 *
  *                : CPU Clock(cclk) = 58.9824 MHz                                                              *           
  *                                                                                                             *
  * Editor         : uVision3 (V3.60)                                                                           *
  * Compiler       : RealView MDK-ARM 3.20        															    *
  * Port Interface :                                                                                            *
  *																											    *
  *            I/O : # MCU-ARM7 LPC2138 #            # ET-REMOTE MP3 #                                          *
  *                  --------------------           -----------------                                           *
  *                                                                                                             *                                   
  *                  P0[16..23](OUT)   connect       Trig CH1-CH8                                               *                                        
  *                  P1[16..23](OUT)   connect       Trig CH9-CH16                                              *                            
  *                  GND               connect       GND                                                        *                                                           
  *                                                                                                    		    *
  * UART0(RS232)  : P0.1 = Rx0                                                                                  *
  *                 P0.0 = Tx0			                                                                        *
  *            	    Baud Rate 9600                                                                              *
  * 																									        *
  *                                                                                  -DIP-SW.MODE               *
  *    Sent CMM      3.3V                                                              S1=OFF,S2=OFF            *
  *   Tx0  Rx0      --+--                                                            -DIP-SW.CONFIG             *
  *    ^    ^         |                                                                S1=OFF,S2=ON             *
  *    |    |         |             																		    *
  *    |    |         |                                                          --------------------			*
  *    |    |   ------+------           Trig Signal CH1-CH8 (Active'0')         |                    |          *
  *    |    |  |       P0.16 |--------------------------------------------------|CH1                 |          *
  *    |    +--|P0.1     .   |                                                  | .                  |          *
  *    |       |         .   |                                                  | .                  |          *
  *    |       |         .   |                                                  | .                  |          *
  *    +-------|P0.0   P0.23 |--------------------------------------------------|CH8                 |          *
  *            |             |                                                  |                    |          *
  *            |             |                                                  |   ET-REMOTE MP3V2  |          *
  *            |             |          Trig Signal CH9-CH16 (Active'0')        |                    |          *
  *            |       P1.16 |--------------------------------------------------|CH9                 |          *
  *            |         .   |                                                  | .                  |          *
  *            |         .   |                                                  | .                  |          *
  *            |         .   |                                                  | .                  |          *
  *            |       P1.23 |--------------------------------------------------|CH16   [Supply]     |          *
  *             -----+------                                                    |       G    5V      |          *
  *                  |LPC2138                                                    -------+-----+------           *
  *                --+--                                                                |     |                 *
  *                 ---                                                                 |     |                 *
  *                  -                                                                  |     +-->5V            *
  *                                                                                   --+--                     *
  *                                                                                    ---                      *
  *                                                                                     -                       *
  *                                                                                                             *
  *                                                                                                             *
  *   ASCII Command For Test :  +----------+-------------+---------------+                                      *
  *                             |Start Byte| Number Song |      End      |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                             |  1Byte   |   2Byte     |    1 Byte     |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                             |    *     |    01-16    |  0x0D (Enter) |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                                                                                                             *
  *                                                                                                             *
  * Last Update     : 7/June/2012                                                                               *   
  * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                      *
  *                                                                                                             * 
  *																											    *
  *                                                                                                             *
  ***************************************************************************************************************/ 
  
  
  
#include "LPC213x.h" 	                             
#include "stdio.h"



 unsigned char enter,cmm_cnt=0,cmm_buf[3] ;
 unsigned int counter ;

 /*************************************
  *         External Function         *
  *************************************/

extern int  sendchar(int ch)   ;  //Function Tx in Serial.c 
extern int  getkey(void)       ;  //Function Rx in Serial.c 
  
 


/**************************************************************  
 *        Interrupt Service routeen Timer0 For Delay(ms) 	  *
 *               (Interrupt every 1 ms) 					  *
 **************************************************************/ 

 void TM0_CNT (void) __irq
   { 
     T0IR        = 1      ;     // Clear interrupt flag  
	 counter = counter+1  ;     //Increment Counter 
     VICVectAddr = 0      ;     // Acknowledge Interrupt 
  }

/****************************************************************************
 *                 Initial Timer0 Control for delay                      	*
 *                                                                          *
 *   -Timer Counter 0 Interrupt executes each 1ms @ 58.9824 MHz CPU Clock   *
 ****************************************************************************/

 void Timer0_Init(void)
  {
   T0MR0        = 29491                   ;    //counts = 1 ms/pclk = 1 ms/33.9084201ns=29491.2
   T0MCR        = 3                       ;    //Interrupt and Reset on MR0
   VICVectAddr1 = (unsigned long) TM0_CNT ;    //set interrupt vector in 1
   VICVectCntl1 = 0x20 | 4                ;    //use it for Enable Vector IRQ Slot Timer0 
   VICIntEnable = 0x00000010              ;    //Enable Timer0 Interrupt Request to update Priority hardware
  }

 

/***************************************************
 *                   Function delay ms 			   *
 ***************************************************/


void delay_ms(unsigned long ms)
 {
  counter = 0              ;   //clear counter
  T0TCR   = 1              ;  // Timer0 Enable
 
  while(counter != ms){;}
  T0TCR   = 0              ;  // Timer0 Disable
 }



 /********************************************************************
  *        Interrupt Service Routine Receive Data From RS-232  		 *
  ********************************************************************/


 void Rx0_data(void)	__irq 
  {

	unsigned char ch ;
	 
	
	   ch = getkey()                ; //Get Data

	   if(ch != 0x0D)           
        {
         //---------------- Keep Command 3 byte : *,cmm,cmm -------------------   
   
         if(cmm_cnt < 3)
           {   
             cmm_buf[cmm_cnt] = ch  ;  // keep data
             cmm_cnt++              ;
           }
        }
   
      //------ Clear Valiable for Recive New Command -------------

       if(ch == 0x0D)               
       {
          enter = 0x0D             ;  
          cmm_cnt = 0              ;  //Clear Counter Command   
       }
	
       ch  = U0IIR                 ;  //Read to Clear Int priority    
	   VICVectAddr = 0             ;  // Acknowledge Interrupt to update Priority hardware
  
  }


 
 /*********************************************
  *              Initial UART0                *
  *********************************************
  *      Initial UART0 = 9600,N,8,1 		  *
  *        VPB(pclk)   = 29.4912 MHz    	  *
  *     U0DLM:U0DLL    = 29.4912MHz/[16xBaud] *
  *                    = 26.4912MHz/[16x9600] *
  *                    = 192=0x00C0     	  *
  *********************************************/

 void UART0_Init(void)
  {
    //--------- Initial Uart0 ----------
   
	U0LCR        = 0x83                     ;  //Conroll Uart1:8bit,1stop,None parity,enable Divisor Latch (83)
    U0DLM        = 0x00                     ;  // Program Divisor Latch  for Baud Rate 9600 ,BR:Byte High  
	U0DLL        = 0xC0                     ;  // BR:Byte Low
    U0LCR        = 0x03                     ;  //Diadble Divisor Latch   
    U0IER        = 0x00000001               ;  //Enable RDA Int(Rx).	
	U0FCR        = 0x07                     ;  //Control Uart0 FIFO:FIFO Enable,Reset Tx,Rx FIFO
	
	VICVectAddr0 = (unsigned long) Rx0_data ;    //set interrupt vector in 0
    VICVectCntl0 = 0x20 | 6                 ;    //use it for Enable Vector IRQ Slot Uart0 
    VICIntEnable = 0x00000040               ;    //Enable Uart0 Interrupt Request

  
  }
 

 /***********************************************************
 **                     Initial Port                      **
 ***********************************************************/
 
 void Init_Port(void)
  {
  //------ Set GPIO  PIN -------

  PINSEL0 = 0x00000005               ;	   //Set Port0-PIN[2..15] = GPIO;Enable RxD0(P0.1) and TxD0(P0.0)
  PINSEL1 = 0x00000000               ;     //Set Port0-PIN[16..31]= GPIO 
  PINSEL2 = 0x00000000               ;     //Set Port1-PIN[16..31]= GPIO 


 //------ Set Direction of GPIO PIN -------

   IODIR0  = 0xFFFFFFFF              ;	   //Set P0.[0..31] = Output
   IODIR1  = 0xFFFFFFFF              ;	   //Set P1.[0..31] = Output
 
 //--------- Default Value P0,P1 ---------

  IOPIN0  = 0xFFFF0000              ;     //Set Data P0.[16...31] = 1
  IOPIN1  = 0xFFFF0000              ;     //Set Data P1.[16...31] = 1
 
  } 

  

 /****************************************************
  **                                                **
  **              Function Read Command             **
  **                                                **
  ****************************************************/ 


void chk_cmm(void)
{
      char cm1,cm2 ; 

     if(enter == 0x0D)                        // Check Enter
     {  
       enter  = 0x00  ;                       // Clear valiable 'enter'
         
         if(cmm_buf[0]== '*')                 // Check Start Byte
          {       
            cm1 = (cmm_buf[1]-0x30)*10    ;   //Convert CMM Ascii to  decimal colum 10
            cm2 = (cmm_buf[2]-0x30)+cm1   ;   //Convert CMM Ascii to  decimal colum 1
                         
                           
              //------------------ Sent Signal Trig Follow Command -----------------------

           switch(cm2)
             {
              case 1 :     //--------------- TRIG-CH1(P0.16)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00010000   ;    //P0.16=0 : Trig-CH1   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET0 = 0x00010000   ;    //P0.16=1  
				    
				
                     printf("#OK\n\r")     ;    //Sent Echo Command 
                   
              break ;

	 
             case 2 :     //--------------- TRIG-CH2(P0.17)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00020000   ;    //P0.17=0 : Trig-CH2   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET0 = 0x00020000   ;    //P0.17=1  
		
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				 
              break ;

              case 3 :     //--------------- TRIG-CH3(P0.18)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00040000   ;    //P0.18=0 : Trig-CH3   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET0 = 0x00040000   ;    //P0.18=1  
				 	
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				
              break ;

              case 4 :     //--------------- TRIG-CH4(P0.19)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00080000   ;    //P0.19=0 : Trig-CH4   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET0 = 0x00080000   ;    //P0.19=1  
 
                     printf("#OK\n\r")     ;    //Sent Echo Command 
			
              break ;
            
              case 5 :     //--------------- TRIG-CH5(P0.20)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00100000   ;    //P0.20=0 : Trig-CH5   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET0 = 0x00100000   ;    //P0.20=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
				 
              break ;
            
              case 6 :     //--------------- TRIG-CH6(P0.21)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00200000   ;    //P0.21=0 : Trig-CH6   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET0 = 0x00200000   ;    //P0.21=1  
              
                     printf("#OK\n\r")     ;    //Sent Echo Command 
		
              break ;
   
              case 7 :     //--------------- TRIG-CH7(P0.22)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00400000   ;    //P0.22=0 : Trig-CH7   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0
 
                     IOSET0 = 0x00400000   ;    //P0.22=1  
                  
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				 
              break ;

              case 8 :     //--------------- TRIG-CH8(P0.23)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR0 = 0x00800000   ;    //P0.23=0 : Trig-CH8   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET0 = 0x00800000   ;    //P0.23=1  
 
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				   
              break ;


            
              case 9 :     //--------------- TRIG-CH9(P1.16)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00010000   ;    //P1.16=0 : Trig-CH9   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00010000   ;    //P1.16=1  
            
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				 
              break ;


             case 10 :     //--------------- TRIG-CH10(P1.17)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00020000   ;    //P1.17=0 : Trig-CH10   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00020000   ;    //P1.17=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
				   
              break ;


             case 11 :     //--------------- TRIG-CH11(P1.18)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00040000   ;    //P1.18=0 : Trig-CH11   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00040000   ;    //P1.18=1  
    
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				   
              break ;


            case 12 :     //--------------- TRIG-CH12(P1.19)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00080000   ;    //P1.19=0 : Trig-CH12   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00080000   ;    //P1.19=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
				  
		      break;

            case 13 :     //--------------- TRIG-CH13(P1.20)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00100000   ;    //P1.20=0 : Trig-CH13   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00100000   ;    //P1.20=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 

              break ;



            case 14 :     //--------------- TRIG-CH14(P1.21)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00200000   ;    //P1.21=0 : Trig-CH14   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00200000   ;    //P1.21=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
					  
              break ;


             case 15 :     //--------------- TRIG-CH15(P1.22)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00400000   ;    //P1.22=0 : Trig-CH15   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00400000   ;    //P1.22=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
				
              break ;


             case 16 :     //--------------- TRIG-CH16(P1.23)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     IOCLR1 = 0x00800000   ;    //P1.23=0 : Trig-CH16   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     IOSET1 = 0x00800000   ;    //P1.23=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
				
              break ;
             
            }   // if switch
          } // if cmm
       }  // if enter


}



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
 {
    
   Init_Port()       ;
   Timer0_Init()     ;
   UART0_Init()      ;

   delay_ms(3000)    ;       //delay for Sync Borad MP3 Ready 

   
   printf("########### ET-REMOTE MP3 V2. ==> PLAY TRIG MODE #########\n\r") ;
  
   while(1)
   {    
     chk_cmm() ;
   }   
 
}



            	 


